-- A stored package that creates the procedure
-- open_cur, used by the Pro*C demo program cv_demo.pc.

CONNECT scott/tiger


CREATE OR REPLACE PACKAGE emp_demo_pkg AS
   TYPE emp_cur_type IS REF CURSOR RETURN emp%ROWTYPE;
   PROCEDURE open_cur(curs IN OUT emp_cur_type, dept_num IN NUMBER);
END emp_demo_pkg;
/

CREATE OR REPLACE PACKAGE BODY emp_demo_pkg AS
    PROCEDURE open_cur(curs IN OUT emp_cur_type, dept_num IN NUMBER) IS
    BEGIN 
        OPEN curs FOR SELECT *
            FROM emp WHERE deptno = dept_num
            ORDER BY ename ASC;
    END;
END emp_demo_pkg;
/

EXIT;
